/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.pinin.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Stream;
import me.towdium.pinin.Keyboard;
import me.towdium.pinin.PinIn;
import me.towdium.pinin.elements.Element;
import me.towdium.pinin.elements.Phoneme;
import me.towdium.pinin.utils.IndexSet;

public class Pinyin
implements Element {
    boolean duo = false;
    public final int id;
    String raw;
    private Phoneme[] phonemes;

    public Pinyin(String str, PinIn p, int id) {
        this.raw = str;
        this.id = id;
        this.reload(str, p);
    }

    public Phoneme[] phonemes() {
        return this.phonemes;
    }

    @Override
    public IndexSet match(String str, int start, boolean partial) {
        Phoneme phoneme;
        if (this.duo) {
            IndexSet ret = IndexSet.ZERO;
            ret = this.phonemes[0].match(str, ret, start, partial);
            ret = this.phonemes[1].match(str, ret, start, partial);
            ret.merge(this.phonemes[2].match(str, ret, start, partial));
            return ret;
        }
        IndexSet active = IndexSet.ZERO;
        IndexSet ret = new IndexSet();
        Phoneme[] phonemeArray = this.phonemes;
        int n = phonemeArray.length;
        for (int i = 0; i < n && !(active = (phoneme = phonemeArray[i]).match(str, active, start, partial)).isEmpty(); ++i) {
            ret.merge(active);
        }
        return ret;
    }

    public String toString() {
        return this.raw;
    }

    public void reload(String str, PinIn p) {
        Collection<String> split = p.keyboard().split(str);
        ArrayList<Phoneme> l = new ArrayList<Phoneme>();
        for (String s : split) {
            l.add(p.getPhoneme(s));
        }
        if (str.charAt(1) == 'h' && p.keyboard() == Keyboard.QUANPIN) {
            boolean slice;
            char sequence = str.charAt(0);
            switch (sequence) {
                case 'z': {
                    slice = !p.fZh2Z();
                    break;
                }
                case 'c': {
                    slice = !p.fCh2C();
                    break;
                }
                case 's': {
                    slice = !p.fSh2S();
                    break;
                }
                default: {
                    slice = false;
                }
            }
            if (slice) {
                l.set(0, p.getPhoneme(Character.toString(sequence)));
                l.add(1, p.getPhoneme("h"));
            }
        }
        this.phonemes = l.toArray(new Phoneme[0]);
        this.duo = p.keyboard().duo;
    }

    public static boolean hasInitial(String s) {
        return Stream.of(Character.valueOf('a'), Character.valueOf('e'), Character.valueOf('i'), Character.valueOf('o'), Character.valueOf('u'), Character.valueOf('v')).noneMatch(i -> s.charAt(0) == i.charValue());
    }
}

